<div align="center">


<h3>Bring real icons to your <a href="https://code.visualstudio.com" target="_blank">Visual Studio Code</a></h3>
<p style="font-size:10px;">minimum supported version: <b>1.82.0</b></p>

</div>


<br/>

![demo](https://raw.githubusercontent.com/vscode-icons/vscode-icons/master/images/screenshot.gif)

---

## Installation

To install the extension just execute the following command in the Command Palette of Visual Studio Code:

```sh
ext install vscode-icons
```

Some people have reported that they cannot find the extension when they insert the installation command.

If you find yourself in the same position, try:

```sh
ext install icons
# or
ext install "vscode-icons"
```

## Usage

Once installed and after reloading `vscode`, you will be presented with a message to `Activate` the icons.

In case this doesn't happen, navigate to:

* `Linux` & `Windows` `=>` **File > Preferences > Theme > File Icon Theme > VSCode Icons**.
* `MacOS` `=>` **Code > Preferences > File Icon Theme > VSCode Icons**.

## Features

`vscode-icons` is being shipped with a lot of features, like:

### Icons Customization

Choose the icon you prefer for any particular file extension.

[Learn more...](https://github.com/vscode-icons/vscode-icons/wiki/Customization)

### Bring your own icons

You don't see the icon you like...? No worries, we got you covered. This link will show you how you can use your own custom icon!

[Learn more...](https://github.com/vscode-icons/vscode-icons/wiki/Custom)

### Project Auto Detection

Are you using Angular? This feature will detect it and enable the icons for you. It also works with other frameworks.

[Learn more...](https://github.com/vscode-icons/vscode-icons/wiki/Pad)

## Documentation

In our [wiki](https://github.com/vscode-icons/vscode-icons/wiki) you can find more information about the extension features and more.

Some examples:

* [Extension's History](https://github.com/vscode-icons/vscode-icons/wiki/History)
* [Supported file icons](https://github.com/vscode-icons/vscode-icons/wiki/ListOfFiles).
* [Supported folder icons](https://github.com/vscode-icons/vscode-icons/wiki/ListOfFolders).

## Globalization

`vscode-icons` uses [Crowdin](https://crowdin.com/project/vscode-icons-i18n) to provide translations for `vscode` supported languages.

We are looking for translators and proofreaders for all `vscode` supported languages.

If you'd like to contribute, checkout the [translation section](https://github.com/vscode-icons/vscode-icons/wiki/Translation).

## Contributing

If you like to get involved with the source code, checkout the [build section](https://github.com/vscode-icons/vscode-icons/wiki/Build).

For those using [Docker](https://www.docker.com/) checkout the [docker section](https://github.com/vscode-icons/vscode-icons/wiki/Docker).

On the other hand, if you want to show the world your artistic side, checkout the [contributing section](https://github.com/vscode-icons/vscode-icons/wiki/Contributing).

In any case, please follow our [contribution guidelines](https://github.com/vscode-icons/vscode-icons/blob/master/.github/CONTRIBUTING.md).

## Credits

Kudos to all [contributors](https://github.com/vscode-icons/vscode-icons/graphs/contributors) that made this extension what it is.

## License

The source code is licensed under the [MIT](https://github.com/vscode-icons/vscode-icons/blob/HEAD/LICENSE) license.

The icons are licensed under the [Creative Commons - ShareAlike (CC BY-SA)](https://creativecommons.org/licenses/by-sa/4.0/) license.

Branded icons are licensed under their copyright license.

## Versioning

`vscode-icons` follows [Semantic Versioning 2.0.0](http://semver.org/).

## Change Log

You can check out all our changes in our [change log](https://github.com/vscode-icons/vscode-icons/blob/master/CHANGELOG.md).

## Acknowledgements

We like to express our "Special Thanks" to:

* All users that made us their favorite **Icons** theme. We wouldn't be where we are without you.

## Related extensions

* [vscode-icons for GitHub](https://github.com/dderevjanik/github-vscode-icons) by [@dderevjanik](https://github.com/dderevjanik) will allow you to see all `GitHub`'s files with `vscode-icons` icons.
* [vscode-icons-js](https://github.com/dderevjanik/vscode-icons-js) by [@dderevjanik](https://github.com/dderevjanik) get file/folder specific icon from `vscode-icons` icons.

**Enjoy!**
