/*
 This is an example configuration file.

 COPY OR RENAME THIS FILE TO config.js.

 Make sure you use real IDs from your HA entities.
*/


var CONFIG = {
   customTheme: CUSTOM_THEMES.MOBILE, // CUSTOM_THEMES.TRANSPARENT, CUSTOM_THEMES.MATERIAL, CUSTOM_THEMES.MOBILE, CUSTOM_THEMES.COMPACT, CUSTOM_THEMES.HOMEKIT, CUSTOM_THEMES.WINPHONE, CUSTOM_THEMES.WIN95
   transition: TRANSITIONS.ANIMATED_GPU, //ANIMATED or SIMPLE (better perfomance)
   entitySize: ENTITY_SIZES.NORMAL, //SMALL, BIG are available
   tileSize: 115,
   tileMargin: 6,
   serverUrl: "https://cutehome.duckdns.org:8123",
   wsUrl: "wss://cutehome.duckdns.org:8123/api/websocket",
   authToken: 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJmNjIxN2E5MzcwYzk0NWEyODA0YmI4YTdkNGM0YTlhYiIsImlhdCI6MTU4NDY4MzMyMCwiZXhwIjoxOTAwMDQzMzIwfQ.u3o_kRFNo8KmtZoeWqxywcCaAq7Vc6N-jRrYdFeefDk', // optional long-lived token (CAUTION: only if TileBoard is not exposed to the internet)
   //googleApiKey: "XXXXXXXXXX", // Required if you are using Google Maps for device tracker
   //mapboxToken: "XXXXXXXXXX", // Required if you are using Mapbox for device tracker
   debug: false, // Prints entities and state change info to the console.
   pingConnection: true, //ping connection to prevent silent disconnections

   // next fields are optional
   events: [],
   timeFormat: 12,
   menuPosition: MENU_POSITIONS.LEFT, // or BOTTOM
   hideScrollbar: false, // horizontal scrollbar
   groupsAlign: GROUP_ALIGNS.HORIZONTALLY, // or VERTICALLY
   onReady: function () {},

   header: { // https://github.com/resoai/TileBoard/wiki/Header-configuration
      styles: {
         padding: '30px 30px 0',
         fontSize: '24px'
      },
      right: [
	     {
            type: HEADER_ITEMS.DATETIME,
            dateFormat: 'EEEE, LLLL dd', //https://docs.angularjs.org/api/ng/filter/date
         }
	  ],
      left: []
   },

   /*screensaver: {// optional. https://github.com/resoai/TileBoard/wiki/Screensaver-configuration
      timeout: 300, // after 5 mins of inactive
      slidesTimeout: 10, // 10s for one slide
      styles: { fontSize: '40px' },
      leftBottom: [{ type: SCREENSAVER_ITEMS.DATETIME }], // put datetime to the left-bottom of screensaver
      slides: [
         { bg: 'images/bg1.jpeg' },
         {
            bg: 'images/bg2.png',
            rightTop: [ // put text to the 2nd slide
               {
                  type: SCREENSAVER_ITEMS.CUSTOM_HTML,
                  html: 'Welcome to the <b>TileBoard</b>',
                  styles: { fontSize: '40px' }
               }
            ]
         },
         { bg: 'images/bg3.jpg' }
      ]
   },*/

   pages: [
      {
         title: 'Main page',
         bg: 'images/bg1.jpeg',
         icon: 'mdi-home-outline', // home icon
//		 header: DEFAULT_HEADER,
         groups: [
            {
               title: 'Living Room',
               width: 5,
               height: 1,
               items: [
				  {
					 type: TYPES.SWITCH,
					 position: [0, 0],
					 title: 'Living Room Light',
					 //subtitle: 'Light',
					 id: 'switch.living_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [1, 0],
					 title: 'Sofa Light',
					 //subtitle: 'Light',
					 id: 'switch.sofa_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },
				  {
					 type: TYPES.SWITCH,
					 position: [2, 0],
					 title: 'TV Light',
					 //subtitle: 'Light',
					 id: 'switch.edge_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [3, 0],
					 title: 'Living fan',
					 //subtitle: 'Light',
					 id: 'switch.living_fan',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-fan",
						off: "mdi-fan-off",
					 },
				  },					  
				  

				  
				  
				  
               ]
            },

            {
               title: 'Dining Room',
               width: 5,
               height: 1,
               items: [
				  {
					 type: TYPES.SWITCH,
					 position: [0, 0],
					 title: 'Dining Light',
					 //subtitle: 'Light',
					 id: 'switch.dining_night_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [1, 0],
					 title: 'Side Table',
					 //subtitle: 'Light',
					 id: 'switch.dining_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },
				  {
					 type: TYPES.SWITCH,
					 position: [2, 0],
					 title: 'Night Light',
					 //subtitle: 'Light',
					 id: 'switch.dining_side_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [3, 0],
					 title: 'Dining fan',
					 //subtitle: 'Light',
					 id: 'switch.dining_fan',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-fan",
						off: "mdi-fan-off",
					 },
				  }					  
  				  
               ]
            },


            {
               title: 'Pantry/Indoor-Kitchen',
               width: 5,
               height: 1,
               items: [
				  {
					 type: TYPES.SWITCH,
					 position: [0, 0],
					 title: 'Pantry Light',
					 //subtitle: 'Light',
					 id: 'switch.pantry_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [1, 0],
					 title: 'Kitchen Light',
					 //subtitle: 'Light',
					 id: 'switch.kitchen_light',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  } 
  				  
               ]
            },

            {
               title: 'Laundry Area',
               width: 5,
               height: 1,
               items: [
				  {
					 type: TYPES.SWITCH,
					 position: [0, 0],
					 title: 'Laundry Light 1',
					 //subtitle: 'Light',
					 id: 'switch.laundrylight01',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [1, 0],
					 title: 'Laundry Light 2',
					 //subtitle: 'Light',
					 id: 'switch.laundrylight02',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },
				  {
					 type: TYPES.SWITCH,
					 position: [2, 0],
					 title: 'Washer/Dryer',
					 //subtitle: 'Light',
					 id: 'switch.washer_dryer',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-washing-machine",
						off: "mdi-washing-machine-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [3, 0],
					 title: 'Laundry fan',
					 //subtitle: 'Light',
					 id: 'switch.sonoff_06',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-fan",
						off: "mdi-fan-off",
					 },
				  }					  
  				  
               ]
            },

            {
               title: 'Porch',
               width: 5,
               height: 1,
               items: [
				  {
					 type: TYPES.SWITCH,
					 position: [0, 0],
					 title: 'Overhead',
					 //subtitle: 'Light',
					 id: 'switch.porchlight',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [1, 0],
					 title: 'Side Lights',
					 //subtitle: 'Light',
					 id: 'switch.porch_side',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },
				  {
					 type: TYPES.SWITCH,
					 position: [2, 0],
					 title: 'Gate Light',
					 //subtitle: 'Light',
					 id: 'switch.gate',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  }	  
  				  
               ]
            },
			
            {
               title: 'Garage',
               width: 5,
               height: 1,
               items: [
				  {
					 type: TYPES.SWITCH,
					 position: [0, 0],
					 title: 'Side Door',
					 //subtitle: 'Light',
					 id: 'switch.garage_sonoff',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [1, 0],
					 title: 'Strada',
					 //subtitle: 'Light',
					 id: 'switch.sonoff2',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },
				  {
					 type: TYPES.SWITCH,
					 position: [2, 0],
					 title: 'Garage Night',
					 //subtitle: 'Light',
					 id: 'switch.sonoff3',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },	
				  {
					 type: TYPES.SWITCH,
					 position: [3, 0],
					 title: 'Revo',
					 //subtitle: 'Light',
					 id: 'switch.revo_light_2',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  }					  
  				  
               ]
            },			

         ]
      },
      {
         title: 'Second page',
         bg: 'images/bg2.png',
         icon: 'mdi-numeric-2-box-outline',
         groups: [
           {
               title: 'Jojit Office',
               width: 4,
               height: 2,
               items: [
				  {
					 type: TYPES.SWITCH,
					 position: [0, 0],
					 title: 'Office Light',
					 //subtitle: 'Light',
					 id: 'switch.sonoff_03_test',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-lightbulb-on",
						off: "mdi-lightbulb-off",
					 },
				  },			   

				  {
					 type: TYPES.SWITCH,
					 position: [1, 0],
					 title: 'Office Fan',
					 //subtitle: 'Fan',
					 id: 'switch.office_fan_2',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-fan",
						off: "mdi-fan-off",
					 },
				  },

				  {
					 type: TYPES.SWITCH,
					 position: [2, 0],
					 title: 'Office Exhaust Fan',
					 //subtitle: 'Fan',
					 id: 'switch.sonoff_th10a',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-fan",
						off: "mdi-fan-off",
					 },
				  },

				  {
					 type: TYPES.SWITCH,
					 position: [3, 0],
					 title: 'Jojit PC',
					 //subtitle: 'Fan',
					 id: 'switch.i5win7',
					 state: false,
					 states: {
						on: "On",
						off: "Off"
					 },
					 icons: {
						on: "mdi-desktop-tower-monitor",
						off: "mdi-monitor-off",
					 },
				  },
				  
                  {
                     position: [0, 1],
                     title: 'Office Temp',
                     //subtitle: '',
                     type: TYPES.SENSOR,
                     id: 'sensor.sonoff_th10a_si7021_temperature', // Assign the sensor you want to display on the gauge
                     unit: 'C', // override default entity unit
					 state: false, // hidding state
					 filter: function (value) { // optional
						var num = parseFloat(value);
						return num && !isNaN(num) ? num.toFixed(1) : value;
					 }
	              },					 
                  {
                     position: [1, 1],
                     title: 'Office Humidity',
                     //subtitle: '',
                     type: TYPES.SENSOR,
                     id: 'sensor.sonoff_th10a_si7021_humidity', // Assign the sensor you want to display on the gauge
                     unit: '%', // override default entity unit
					 state: false, // hidding state
					 filter: function (value) { // optional
						var num = parseFloat(value);
						return num && !isNaN(num) ? num.toFixed(1) : value;
					 }					 
	              },

                  {
                     position: [2, 1],
                     title: 'PC Power',
                     //subtitle: '',
                     type: TYPES.SENSOR,
                     id: 'sensor.sonoff_s31a_energy_power', // Assign the sensor you want to display on the gauge
                     unit: 'W', // override default entity unit
					 state: false, // hidding state
					 filter: function (value) { // optional
						var num = parseFloat(value);
						return num && !isNaN(num) ? num.toFixed(1) : value;
					 }					 
	              },
				  
				                    {
                     position: [3, 1],
                     title: 'PC Energy',
                     //subtitle: '',
                     type: TYPES.SENSOR,
                     id: 'sensor.sonoff_s31a_energy_today', // Assign the sensor you want to display on the gauge
                     unit: 'kWh', // override default entity unit
					 state: false, // hidding state
					 filter: function (value) { // optional
						var num = parseFloat(value);
						return num && !isNaN(num) ? num.toFixed(1) : value;
					 }					 
	              },

               ]
            },		 
		 
            {
               title: '',
               width: 2,
               height: 3,
               items: [
				  {
					 position: [0, 0],
                     type: TYPES.DEVICE_TRACKER,
                     id: 'device_tracker.google_maps_118328263552408103785',
                     map: 'yandex',
				     states: {
						home: "Home",
						not_home: "Away",
						work: "Work",
					 },
					 zoomLevels: [9, 13], // or [9] for only one map slide
				     hideEntityPicture: false, //hide entity pic, if you need only map
				     slidesDelay: 2 // delay before first slide animation
				  },

               ]
            },
         ]
      }
   ],
}
